\name{Rclient}
\title{Functions to talk to an Rserve}
\alias{Rclient}
\alias{RSconnect}
\alias{RSclose}
\alias{RSeval}
\alias{RSlogin}
\alias{RSdetach}
\alias{RSevalDetach}
\alias{RSattach}
\alias{RSassign}
\alias{RSshutdown}
\alias{RSserverEval}
\alias{RSserverSource}
\usage{
RSconnect(host = "localhost", port = 6311)
RSlogin(c, user, pwd, silent = FALSE)
RSeval(c, expr)
RSclose(c)
RSshutdown(c, pwd = NULL, ctrl = FALSE)
RSdetach(c)
RSevalDetach(c, cmd = "")
RSattach(session)
RSassign(c, obj, name = deparse(substitute(obj)) )
RSserverEval(c, expr)
RSserverSource(c, file)
}
\description{
  Rserve is a server providing R functionality via sockets. The
  following functions allow another R session to start new Rserve
  sessions and evaluate commands. The support is very rudimentary and
  uses only a fraction of the funtionality provided by Rserve. The
  typical use of Rserve is to connect to other applications, not
  necessarily to connect two R processes. However, it is not uncommon to
  have a cluster of Rserve machines so the following functions provide a
  simple client access.

  For more complete cilent implementation see \code{src/clients}
  directory of the Rserve distribution which show a C/C++ client. Also
  available from the Rserve pages is a Java client
  (\code{JRclient}). See \code{http://rosuda.org/Rserve} for details.
}
\arguments{
  \item{host}{host to connect to}
  \item{port}{TCP port to connect to}
  \item{c}{Rserve connection}
  \item{user}{username for authentication}
  \item{pwd}{password for authentication}
  \item{cmd}{command (as string) to evaluate}
  \item{silent}{flag indicating whether a failure should raise an error
    or not}
  \item{session}{session object as returned by \code{RSdetach} or
    \code{RSevalDetach}}
  \item{obj}{value to assign}
  \item{name}{name to assign to on the remote side}
  \item{expr}{R expression to evaluate remotely}
  \item{file}{path to a file on the server(!) that will be sourced into
    the main instance}
  \item{ctrl}{logical, if \code{TRUE} then control command
    (\code{CMD_ctrlShutdown}) is used for shutdown, otherwise the
    legacy \code{CMD_shutdown} is used instead.}
}
\details{
  \code{RSconnect} creates a connection to a Rserve. The returned handle
  is to be used in all subsequent calls to client functions. The session
  associated witht he connection is alive until closed via
  \code{RSclose}.

  \code{RSlogin} performs authentication with the Rserve. Currently this
  simple client supports only plain text authentication, encryption is
  not supported.

  \code{RSclose} closes the Rserve connection.

  \code{RSeval} evaluates the supplied expression
  remotely. \code{expr} can be either a string or any R
  expression. Use \code{\link{quote}} to use unevaluated
  expressions. The implementation of \code{RSeval} is very efficient
  in that it does not require any buffer on the remote side and uses
  native R serialization as the protocol. See exmples below for
  correct use.

  \code{RSdetach} detaches from the current Rserve connection. The
  connection is closed but can be restored by using \code{RSattach} with
  the value returned by \code{RSdetach}. Technically the R on the other
  end is still running and waiting to be atached.

  \code{RSshutdown} terminates the server gracefully. It should be
  immediately followed by \code{RSclose} since the server closes the
  connection. It can be issued only on a valid (authenticated)
  connection. The password parameter is currently ignored since
  password-protected shutdown is not yet supported. Please note that
  you should not terminate servers that you did not start. More recent
  Rserve installation can disable regular shutdown and only allow
  control shutdown (avaiable to control users only) which is invoked
  by specifying \code{ctrl=TRUE}.

  \code{RSevalDetach} same as \code{RSdetach} but allows asynchronous
  evaluation of the command. The remote Rserve is instructed to evaluate
  the command after the connection is detached. Please note that the
  session cannot be attached until the evaluation finished. Therefore it
  is advisable to use another session when attaching to verify the
  status of the detached session where necessary.

  \code{RSattach} resume connection to an existing session in
  Rserve. The \code{session} argument must have been previously returned
  from the \code{RSdetach} or \code{RSevalDetach} comment.

  \code{RSassign} pushes an object to Rserve and assigns it to the given
  name. Note that the name can be an (unevaluated) R expression itself
  thus allowing constructs such as \code{RSassign(c, 1:5,
  quote(a$foo))} which will result in \code{a$foo <- 1:5}
  remotely. However, character names are interpreted literarly.

  \code{RSserverEval} and \code{RSserverSource} enqueue commands in the
  server instance of Rserve, i.e. their effect will be visible for all
  subsequent client connections. The Rserve instance must have control
  commands enabled (not the default) in order to allow those
  commands. \code{RSserverEval} evaluates the supplied expression and
  \code{RSserverSource} sources the specified file - it must be a valid
  path to a file on the server, not the client machine! Both commands
  are executed asynchronously in the server, so the success of those
  commands only means that they were queued on the server - they will be
  executed between subsequent client connections. Note that only
  subsequent connections will be affected, not the one issuing those
  commands.
}
\examples{
\dontrun{
  c <- RSconnect()
  data(stackloss)
  RSassign(c, stackloss)
  RSeval(c, quote(library(MASS)))
  RSeval(c, quote(rlm(stack.loss ~ ., stackloss)$coeff))
  RSeval(c, "getwd()")
  
  image <- RSeval(c, quote(try({
    attach(stackloss)
    library(Cairo)
    Cairo(file="plot.png")
    plot(Air.Flow,stack.loss,col=2,pch=19,cex=2)
    dev.off()
    readBin("plot.png", "raw", 999999)})))
  if (inherits(image, "try-error"))
    stop(image)
}
}
\author{Simon Urbanek}
\keyword{interface}
